import { Navbar } from "@/components/navbar"
import { Footer } from "@/components/footer"
import { IdeaCard } from "@/components/idea-card"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"
import { PlusCircle, Search } from "lucide-react"
import Image from "next/image"

export default function IdeaBoard() {
  // Sample idea data
  const ideas = [
    {
      id: 1,
      title: "AI Physics Simulator",
      description: "A tool to visualize physics concepts in 3D with interactive simulations.",
      tags: ["Physics", "AI", "Education"],
      author: "Drisana M.",
      avatar: "/images/avatar-1.jpg",
      image: "/images/idea-physics.jpg",
      likes: 42,
      comments: 8,
      createdAt: "2 days ago",
    },
    {
      id: 2,
      title: "Collaborative Math Problem Solver",
      description: "Platform where students can work together to solve complex math problems step by step.",
      tags: ["Mathematics", "Collaboration", "Problem-Solving"],
      author: "Miguel R.",
      avatar: "/images/avatar-2.jpg",
      image: "/images/idea-math.jpg",
      likes: 36,
      comments: 12,
      createdAt: "3 days ago",
    },
    {
      id: 3,
      title: "Literature Analysis Tool",
      description:
        "AI-powered tool that helps students analyze literary works and identify themes, motifs, and character development.",
      tags: ["Literature", "AI", "Analysis"],
      author: "Sarah J.",
      avatar: "/images/avatar-3.jpg",
      image: "/images/idea-literature.jpg",
      likes: 29,
      comments: 5,
      createdAt: "5 days ago",
    },
    {
      id: 4,
      title: "Chemistry Lab Simulator",
      description:
        "Virtual chemistry lab where students can conduct experiments safely and learn about chemical reactions.",
      tags: ["Chemistry", "Virtual Lab", "Science"],
      author: "David C.",
      avatar: "/images/avatar-4.jpg",
      image: "/images/idea-chemistry.jpg",
      likes: 51,
      comments: 14,
      createdAt: "1 week ago",
    },
    {
      id: 5,
      title: "Historical Timeline Creator",
      description: "Tool for creating interactive timelines for historical events with multimedia integration.",
      tags: ["History", "Timeline", "Interactive"],
      author: "Emma L.",
      avatar: "/images/avatar-5.jpg",
      image: "/images/idea-history.jpg",
      likes: 33,
      comments: 7,
      createdAt: "1 week ago",
    },
    {
      id: 6,
      title: "Language Exchange Platform",
      description: "Connect students learning different languages for conversation practice and cultural exchange.",
      tags: ["Languages", "Exchange", "Communication"],
      author: "Carlos M.",
      avatar: "/images/avatar-6.jpg",
      image: "/images/idea-language.jpg",
      likes: 47,
      comments: 19,
      createdAt: "2 weeks ago",
    },
  ]

  return (
    <div className="min-h-screen flex flex-col">
      <Navbar />

      <main className="flex-grow">
        <div className="bg-teal-500 text-white py-12 relative overflow-hidden">
          <div className="absolute inset-0 z-0">
            <Image
              src="https://hebbkx1anhila5yf.public.blob.vercel-storage.com/Idea%20Board.png-eDQruIZbXTT9TIvlvSPS5SxtC6uF2y.jpeg"
              alt="Idea Board Background"
              fill
              className="object-cover opacity-20"
            />
          </div>
          <div className="container mx-auto px-4 relative z-10">
            <h1 className="text-3xl md:text-4xl font-bold mb-4">Idea Board</h1>
            <p className="text-xl max-w-3xl">
              Share your innovative ideas, get feedback from peers, and collaborate on turning concepts into reality.
            </p>
          </div>
        </div>

        <div className="container mx-auto px-4 py-8">
          <div className="flex flex-col md:flex-row justify-between items-start md:items-center gap-4 mb-8">
            <div className="relative w-full md:w-96">
              <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400" size={18} />
              <Input placeholder="Search ideas..." className="pl-10" />
            </div>

            <Button className="bg-teal-500 hover:bg-teal-600">
              <PlusCircle className="mr-2 h-4 w-4" />
              Post New Idea
            </Button>
          </div>

          <Tabs defaultValue="trending" className="mb-8">
            <TabsList>
              <TabsTrigger value="trending">Trending</TabsTrigger>
              <TabsTrigger value="recent">Recent</TabsTrigger>
              <TabsTrigger value="following">Following</TabsTrigger>
              <TabsTrigger value="my-ideas">My Ideas</TabsTrigger>
            </TabsList>
            <TabsContent value="trending" className="mt-6">
              <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                {ideas.map((idea) => (
                  <IdeaCard key={idea.id} idea={idea} />
                ))}
              </div>
            </TabsContent>
            <TabsContent value="recent">
              <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                {/* Would show recent ideas */}
                <div className="col-span-full py-12 text-center text-gray-500">Sign in to view recent ideas</div>
              </div>
            </TabsContent>
            <TabsContent value="following">
              <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                {/* Would show followed ideas */}
                <div className="col-span-full py-12 text-center text-gray-500">
                  Sign in to view ideas from people you follow
                </div>
              </div>
            </TabsContent>
            <TabsContent value="my-ideas">
              <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                {/* Would show user's ideas */}
                <div className="col-span-full py-12 text-center text-gray-500">Sign in to view your ideas</div>
              </div>
            </TabsContent>
          </Tabs>
        </div>
      </main>

      <Footer />
    </div>
  )
}
