import { Navbar } from "@/components/navbar"
import { Footer } from "@/components/footer"
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"
import { PlusCircle, Search } from "lucide-react"
import Image from "next/image"

export default function TeacherHub() {
  const resources = [
    {
      id: 1,
      title: "Advanced Calculus Lesson Plans",
      subject: "Mathematics",
      author: "Prof. David Chen",
      downloads: 245,
      rating: 4.8,
      image: "/images/math-lesson.jpg",
      type: "Lesson Plan",
    },
    {
      id: 2,
      title: "Physics Lab Experiments Guide",
      subject: "Physics",
      author: "Dr. Sarah Johnson",
      downloads: 189,
      rating: 4.9,
      image: "/images/physics-lab-guide.jpg",
      type: "Lab Guide",
    },
    {
      id: 3,
      title: "Literature Analysis Worksheets",
      subject: "Literature",
      author: "Emma Lewis",
      downloads: 156,
      rating: 4.7,
      image: "/images/literature-worksheets.jpg",
      type: "Worksheet",
    },
    {
      id: 4,
      title: "Chemistry Safety Protocols",
      subject: "Chemistry",
      author: "Dr. Michael Brown",
      downloads: 203,
      rating: 4.9,
      image: "/images/chemistry-safety.jpg",
      type: "Guide",
    },
  ]

  return (
    <div className="min-h-screen flex flex-col">
      <Navbar />

      <main className="flex-grow">
        <div className="bg-teal-500 text-white py-12 relative overflow-hidden">
          <div className="absolute inset-0 z-0">
            <Image
              src="https://hebbkx1anhila5yf.public.blob.vercel-storage.com/Teacher%20Hub-Cnhf1wdwfplhii0xyFZseaXI7KFpeH.jpeg"
              alt="Teacher Hub Background"
              fill
              className="object-cover opacity-20"
            />
          </div>
          <div className="container mx-auto px-4 relative z-10">
            <h1 className="text-3xl md:text-4xl font-bold mb-4">Teacher Hub</h1>
            <p className="text-xl max-w-3xl">
              Create, share, and discover educational resources. Connect with fellow educators and enhance your teaching
              materials.
            </p>
          </div>
        </div>

        <div className="container mx-auto px-4 py-8">
          <div className="flex flex-col md:flex-row justify-between items-start md:items-center gap-4 mb-8">
            <div className="relative w-full md:w-96">
              <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400" size={18} />
              <Input placeholder="Search resources..." className="pl-10" />
            </div>

            <Button className="bg-teal-500 hover:bg-teal-600">
              <PlusCircle className="mr-2 h-4 w-4" />
              Upload Resource
            </Button>
          </div>

          <Tabs defaultValue="resources" className="mb-8">
            <TabsList>
              <TabsTrigger value="resources">All Resources</TabsTrigger>
              <TabsTrigger value="my-resources">My Resources</TabsTrigger>
              <TabsTrigger value="favorites">Favorites</TabsTrigger>
              <TabsTrigger value="recent">Recent</TabsTrigger>
            </TabsList>

            <TabsContent value="resources" className="mt-6">
              <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                {resources.map((resource) => (
                  <Card key={resource.id} className="overflow-hidden hover:shadow-lg transition-shadow">
                    <div className="relative h-48">
                      <Image
                        src={resource.image || "/placeholder.svg"}
                        alt={resource.title}
                        fill
                        className="object-cover"
                      />
                      <div className="absolute top-2 right-2 bg-white/90 text-teal-800 px-2 py-1 rounded text-xs font-medium">
                        {resource.type}
                      </div>
                    </div>
                    <CardHeader>
                      <CardTitle className="text-lg">{resource.title}</CardTitle>
                      <CardDescription>
                        {resource.subject} • by {resource.author}
                      </CardDescription>
                    </CardHeader>
                    <CardContent>
                      <div className="flex items-center justify-between text-sm text-gray-500">
                        <span>{resource.downloads} downloads</span>
                        <span>⭐ {resource.rating}</span>
                      </div>
                    </CardContent>
                    <CardFooter className="flex gap-2">
                      <Button variant="outline" className="flex-1">
                        Preview
                      </Button>
                      <Button className="flex-1 bg-teal-500 hover:bg-teal-600">Download</Button>
                    </CardFooter>
                  </Card>
                ))}
              </div>
            </TabsContent>

            <TabsContent value="my-resources">
              <div className="py-12 text-center text-gray-500">Sign in to view your uploaded resources</div>
            </TabsContent>

            <TabsContent value="favorites">
              <div className="py-12 text-center text-gray-500">Sign in to view your favorite resources</div>
            </TabsContent>

            <TabsContent value="recent">
              <div className="py-12 text-center text-gray-500">Sign in to view recently accessed resources</div>
            </TabsContent>
          </Tabs>

          <div className="bg-gray-50 rounded-xl p-6 mt-12">
            <div className="flex flex-col md:flex-row items-start md:items-center gap-6">
              <div className="relative w-full md:w-1/3 h-48 rounded-lg overflow-hidden">
                <Image
                  src="https://hebbkx1anhila5yf.public.blob.vercel-storage.com/Teacher%20Hub-Cnhf1wdwfplhii0xyFZseaXI7KFpeH.jpeg"
                  alt="Teacher Collaboration"
                  fill
                  className="object-cover"
                />
              </div>
              <div className="md:w-2/3">
                <h2 className="text-2xl font-bold mb-2">Join the Educator Community</h2>
                <p className="text-gray-600 mb-4">
                  Connect with thousands of educators worldwide. Share your expertise, learn from others, and
                  collaborate on creating better educational experiences for students.
                </p>
                <div className="flex flex-wrap gap-4">
                  <Button className="bg-teal-500 hover:bg-teal-600">Join Community</Button>
                  <Button variant="outline">Browse Forums</Button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </main>

      <Footer />
    </div>
  )
}
