"use client"

import { useState } from "react"
import Link from "next/link"
import Image from "next/image"
import { Button } from "@/components/ui/button"
import { Menu, X } from "lucide-react"

export function Navbar() {
  const [isMenuOpen, setIsMenuOpen] = useState(false)

  const toggleMenu = () => {
    setIsMenuOpen(!isMenuOpen)
  }

  return (
    <header className="sticky top-0 z-50 w-full border-b bg-white/80 backdrop-blur-sm">
      <div className="container mx-auto px-4">
        <div className="flex h-28 items-center justify-between">
          <div className="flex items-center">
            <Link href="/" className="flex items-center">
              <Image
                src="/images/logo.png"
                alt="Dolabing Logo"
                width={400}
                height={106}
                className="h-20 w-auto"
                priority
              />
            </Link>
          </div>

          {/* Desktop Navigation */}
          <nav className="hidden lg:flex items-center gap-6">
            <Link href="/idea-board" className="text-sm font-medium hover:text-teal-500 transition-colors">
              Idea Board
            </Link>
            <Link href="/practice-labs" className="text-sm font-medium hover:text-teal-500 transition-colors">
              Practice Labs
            </Link>
            <Link href="/live-study" className="text-sm font-medium hover:text-teal-500 transition-colors">
              Live Study
            </Link>
            <Link href="/teacher-hub" className="text-sm font-medium hover:text-teal-500 transition-colors">
              Teacher Hub
            </Link>
            <Link href="/projects" className="text-sm font-medium hover:text-teal-500 transition-colors">
              Project Hubs
            </Link>
          </nav>

          <div className="hidden lg:flex items-center gap-4">
            <Button variant="outline" asChild>
              <Link href="/login">Log In</Link>
            </Button>
            <Button className="bg-teal-500 hover:bg-teal-600" asChild>
              <Link href="/signup">Sign Up</Link>
            </Button>
          </div>

          {/* Mobile Menu Button */}
          <button className="lg:hidden" onClick={toggleMenu} aria-label="Toggle menu">
            {isMenuOpen ? <X className="h-6 w-6" /> : <Menu className="h-6 w-6" />}
          </button>
        </div>
      </div>

      {/* Mobile Navigation */}
      {isMenuOpen && (
        <div className="lg:hidden border-t py-4">
          <div className="container mx-auto px-4 flex flex-col gap-4">
            <Link
              href="/idea-board"
              className="text-sm font-medium py-2 hover:text-teal-500 transition-colors"
              onClick={() => setIsMenuOpen(false)}
            >
              Idea Board
            </Link>
            <Link
              href="/practice-labs"
              className="text-sm font-medium py-2 hover:text-teal-500 transition-colors"
              onClick={() => setIsMenuOpen(false)}
            >
              Practice Labs
            </Link>
            <Link
              href="/live-study"
              className="text-sm font-medium py-2 hover:text-teal-500 transition-colors"
              onClick={() => setIsMenuOpen(false)}
            >
              Live Study
            </Link>
            <Link
              href="/teacher-hub"
              className="text-sm font-medium py-2 hover:text-teal-500 transition-colors"
              onClick={() => setIsMenuOpen(false)}
            >
              Teacher Hub
            </Link>
            <Link
              href="/projects"
              className="text-sm font-medium py-2 hover:text-teal-500 transition-colors"
              onClick={() => setIsMenuOpen(false)}
            >
              Project Hubs
            </Link>
            <div className="flex flex-col gap-2 pt-2 border-t">
              <Button variant="outline" asChild className="w-full">
                <Link href="/login">Log In</Link>
              </Button>
              <Button className="w-full bg-teal-500 hover:bg-teal-600" asChild>
                <Link href="/signup">Sign Up</Link>
              </Button>
            </div>
          </div>
        </div>
      )}
    </header>
  )
}
