import Image from "next/image"
import { Card, CardContent } from "@/components/ui/card"

export function Testimonials() {
  const testimonials = [
    {
      quote:
        "Dolabing has transformed how our students collaborate on projects. The idea board is a game-changer for brainstorming sessions!",
      name: "Dr. Sarah Johnson",
      role: "High School Principal",
      avatar:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/dr--sarah-johnson-high-school-principal-yHD34yXwaY6ckpUQpEOLWUUq48l5X3.png",
    },
    {
      quote:
        "As a student, I love how the Practice Labs help me prepare for exams while making learning fun with the points system.",
      name: "Miguel Rodriguez",
      role: "College Student",
      avatar:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/miguel-rodriguez-college-student-McsYMJdaob2m1cJRLhXb20DgZbBXRG.png",
    },
    {
      quote: "The Live Study Cyberspace has made remote learning feel connected and engaging for all my students.",
      name: "Prof. David Chen",
      role: "University Lecturer",
      avatar:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/prof--david-chen-university-lecturer-7vYAdT0TniFZxW9vL87B3UtIlZxLiu.png",
    },
  ]

  return (
    <section className="py-20 bg-teal-50">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">What Our Users Say</h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Hear from students, teachers, and administrators who are using Dolabing to transform their learning
            experience.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {testimonials.map((testimonial, index) => (
            <Card key={index} className="border-none shadow-lg">
              <CardContent className="p-8">
                <div className="flex items-center mb-6">
                  <div className="relative w-20 h-20 rounded-full overflow-hidden mr-4">
                    <Image
                      src={testimonial.avatar || "/placeholder.svg"}
                      alt={testimonial.name}
                      fill
                      className="object-cover"
                    />
                  </div>
                  <div>
                    <h4 className="font-bold">{testimonial.name}</h4>
                    <p className="text-gray-500">{testimonial.role}</p>
                  </div>
                </div>
                <p className="italic text-gray-700">"{testimonial.quote}"</p>
              </CardContent>
            </Card>
          ))}
        </div>
      </div>
    </section>
  )
}
