import { BookOpen, Lightbulb, Users, Laptop, Award, BarChart } from "lucide-react"
import Image from "next/image"

export function Features() {
  const features = [
    {
      icon: <Lightbulb className="h-10 w-10 text-teal-500" />,
      title: "Idea Board",
      description: "Share and collaborate on innovative ideas with peers and mentors.",
      image:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/Idea%20Board.png-eDQruIZbXTT9TIvlvSPS5SxtC6uF2y.jpeg",
    },
    {
      icon: <BookOpen className="h-10 w-10 text-teal-500" />,
      title: "Practice Labs",
      description: "Interactive subject-specific quizzes and exercises to enhance learning.",
      image:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/Practice%20Labs-MKdKuignIEMrL3hD2ZBqg45iE4h7LL.png",
    },
    {
      icon: <Users className="h-10 w-10 text-teal-500" />,
      title: "Live Study Cyberspace",
      description: "Real-time collaboration spaces for group study and discussions.",
      image:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/Live%20Study%20Cyberspace-DzZs9tldaBYR33ceSUelcs7YKP91Zl.jpeg",
    },
    {
      icon: <Laptop className="h-10 w-10 text-teal-500" />,
      title: "Teacher Hub",
      description: "Resources and tools for educators to create and share learning materials.",
      image:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/Teacher%20Hub-Cnhf1wdwfplhii0xyFZseaXI7KFpeH.jpeg",
    },
    {
      icon: <Award className="h-10 w-10 text-teal-500" />,
      title: "Project Hubs",
      description: "Collaborative project spaces with file sharing and task management.",
      image:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/Project%20Hubs-3SrsY1xgDmkCHUD6c7uqiyat15f7a7.jpeg",
    },
    {
      icon: <BarChart className="h-10 w-10 text-teal-500" />,
      title: "Activity Profiles",
      description: "Track progress and achievements with gamified learning profiles.",
      image:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/Activity%20Profiles.jpg-p5JKRPWozNIIGuOtQ2WzIH6gBdfbKb.jpeg",
    },
  ]

  return (
    <section className="py-20 bg-gray-50">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">Platform Features</h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Discover the tools that make Dolabing the ultimate social lab for learning and collaboration.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {features.map((feature, index) => (
            <div
              key={index}
              className="bg-white rounded-xl shadow-md overflow-hidden hover:shadow-lg transition-shadow"
            >
              <div className="relative h-48">
                <Image src={feature.image || "/placeholder.svg"} alt={feature.title} fill className="object-cover" />
              </div>
              <div className="p-6">
                <div className="mb-4">{feature.icon}</div>
                <h3 className="text-xl font-bold mb-2">{feature.title}</h3>
                <p className="text-gray-600">{feature.description}</p>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
