import Link from "next/link"
import Image from "next/image"
import { Facebook, Twitter, Instagram, Linkedin, Github, Mail, Phone, MapPin } from "lucide-react"

export function Footer() {
  return (
    <footer className="bg-gradient-to-br from-teal-600 via-teal-700 to-teal-800 text-white">
      <div className="container mx-auto px-4 py-16">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          <div>
            <Link href="/" className="inline-block mb-6">
              <Image src="/images/logo-white.png" alt="Dolabing Logo" width={150} height={40} className="h-auto" />
            </Link>
            <p className="text-teal-100 mb-6">
              A social lab platform for students, creators, teachers, and school authorities to ideate, collaborate,
              learn, build, and share.
            </p>
            <div className="flex space-x-4">
              <Link href="#" className="text-teal-200 hover:text-white transition-colors">
                <Facebook size={20} />
              </Link>
              <Link href="#" className="text-teal-200 hover:text-white transition-colors">
                <Twitter size={20} />
              </Link>
              <Link href="#" className="text-teal-200 hover:text-white transition-colors">
                <Instagram size={20} />
              </Link>
              <Link href="#" className="text-teal-200 hover:text-white transition-colors">
                <Linkedin size={20} />
              </Link>
              <Link href="#" className="text-teal-200 hover:text-white transition-colors">
                <Github size={20} />
              </Link>
            </div>
          </div>

          <div>
            <h3 className="text-lg font-bold mb-6">Features</h3>
            <ul className="space-y-4">
              <li>
                <Link href="/idea-board" className="text-teal-200 hover:text-white transition-colors">
                  Idea Board
                </Link>
              </li>
              <li>
                <Link href="/practice-labs" className="text-teal-200 hover:text-white transition-colors">
                  Practice Labs
                </Link>
              </li>
              <li>
                <Link href="/live-study" className="text-teal-200 hover:text-white transition-colors">
                  Live Study Cyberspace
                </Link>
              </li>
              <li>
                <Link href="/teacher-hub" className="text-teal-200 hover:text-white transition-colors">
                  Teacher Hub
                </Link>
              </li>
              <li>
                <Link href="/projects" className="text-teal-200 hover:text-white transition-colors">
                  Project Hubs
                </Link>
              </li>
            </ul>
          </div>

          <div>
            <h3 className="text-lg font-bold mb-6">Resources</h3>
            <ul className="space-y-4">
              <li>
                <Link href="/help" className="text-teal-200 hover:text-white transition-colors">
                  Help Center
                </Link>
              </li>
              <li>
                <Link href="/tutorials" className="text-teal-200 hover:text-white transition-colors">
                  Tutorials
                </Link>
              </li>
              <li>
                <Link href="/blog" className="text-teal-200 hover:text-white transition-colors">
                  Blog
                </Link>
              </li>
              <li>
                <Link href="/events" className="text-teal-200 hover:text-white transition-colors">
                  Events
                </Link>
              </li>
            </ul>
          </div>

          <div>
            <h3 className="text-lg font-bold mb-6">Contact Us</h3>
            <div className="space-y-4">
              <div className="flex items-center space-x-3">
                <Mail className="h-5 w-5 text-teal-300" />
                <a href="mailto:markettist@gmail.com" className="text-teal-200 hover:text-white transition-colors">
                  markettist@gmail.com
                </a>
              </div>
              <div className="flex items-center space-x-3">
                <Phone className="h-5 w-5 text-teal-300" />
                <a href="tel:+8801794130123" className="text-teal-200 hover:text-white transition-colors">
                  +880 179 413 0123
                </a>
              </div>
              <div className="flex items-start space-x-3">
                <MapPin className="h-5 w-5 text-teal-300 mt-1" />
                <div className="text-teal-200">
                  <p>Dhaka, Bangladesh</p>
                </div>
              </div>
            </div>

            <div className="mt-6">
              <h4 className="text-md font-semibold mb-3">Quick Links</h4>
              <ul className="space-y-2">
                <li>
                  <Link href="/about" className="text-teal-200 hover:text-white transition-colors text-sm">
                    About Us
                  </Link>
                </li>
                <li>
                  <Link href="/contact" className="text-teal-200 hover:text-white transition-colors text-sm">
                    Contact
                  </Link>
                </li>
                <li>
                  <Link href="/careers" className="text-teal-200 hover:text-white transition-colors text-sm">
                    Careers
                  </Link>
                </li>
                <li>
                  <Link href="/privacy" className="text-teal-200 hover:text-white transition-colors text-sm">
                    Privacy Policy
                  </Link>
                </li>
                <li>
                  <Link href="/terms" className="text-teal-200 hover:text-white transition-colors text-sm">
                    Terms of Service
                  </Link>
                </li>
              </ul>
            </div>
          </div>
        </div>

        <div className="border-t border-teal-600 mt-12 pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center">
            <div className="text-teal-200 text-center md:text-left">
              <p>&copy; {new Date().getFullYear()} Dolabing. All rights reserved.</p>
            </div>
            <div className="flex items-center space-x-4 mt-4 md:mt-0">
              <span className="text-teal-200 text-sm">Follow us:</span>
              <div className="flex space-x-3">
                <Link href="#" className="text-teal-200 hover:text-white transition-colors">
                  <Facebook size={16} />
                </Link>
                <Link href="#" className="text-teal-200 hover:text-white transition-colors">
                  <Twitter size={16} />
                </Link>
                <Link href="#" className="text-teal-200 hover:text-white transition-colors">
                  <Instagram size={16} />
                </Link>
                <Link href="#" className="text-teal-200 hover:text-white transition-colors">
                  <Linkedin size={16} />
                </Link>
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>
  )
}
