"use client"

import { useState, useEffect } from "react"
import Image from "next/image"
import { Button } from "@/components/ui/button"
import Link from "next/link"

export function HeroCarousel() {
  const heroImages = [
    {
      src: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/create-a-series-of-visually-stunning-hero-images-f-Vv6vXx6OUKedoAIlO5h6P2DkTMSgO5.png",
      alt: "Student with creative learning environment",
      title: "Do+Lab+Ing What You Love!",
      subtitle:
        "A social lab platform for students, creators, teachers, and school authorities to ideate, collaborate, learn, build, and share.",
    },
    {
      src: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/create-a-series-of-visually-stunning-hero-images-f%20%281%29-Na8MaJ4jIDR2MDjkqdbFe92sRE8GQs.png",
      alt: "Innovation and networking",
      title: "Connect & Innovate Together!",
      subtitle: "Join a global community of learners and creators building the future through collaboration.",
    },
    {
      src: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/create-a-series-of-visually-stunning-hero-images-f%20%282%29-mlbXvxOhJmjAIyUJAQKONPObPZhGmQ.png",
      alt: "Creative workspace learning",
      title: "Create Your Learning Journey!",
      subtitle: "Personalize your education with interactive labs, idea boards, and project collaboration.",
    },
    {
      src: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/create-a-series-of-visually-stunning-hero-images-f%20%286%29-hvUbZbuwjqdSLh7KZPDhGoGjljD1C7.png",
      alt: "Diverse classroom collaboration",
      title: "Learn Together, Grow Together!",
      subtitle: "Experience the power of peer-driven learning in our inclusive digital classroom.",
    },
    {
      src: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/create-a-series-of-visually-stunning-hero-images-f%20%289%29-xS0ZFpwONWb7pBGNj69vk1m2b3u6HU.png",
      alt: "Students collaborating",
      title: "Collaborate & Build Ideas!",
      subtitle: "Transform your curiosity into real-world solutions with fellow students and mentors.",
    },
  ]

  const [currentIndex, setCurrentIndex] = useState(0)

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prevIndex) => (prevIndex + 1) % heroImages.length)
    }, 5000) // Change image every 5 seconds

    return () => clearInterval(interval)
  }, [heroImages.length])

  const currentHero = heroImages[currentIndex]

  return (
    <section className="relative h-[700px] md:h-[800px] flex items-center bg-gradient-to-br from-teal-400 via-teal-500 to-teal-600 overflow-hidden">
      <div className="absolute inset-0 z-0">
        <Image
          src={currentHero.src || "/placeholder.svg"}
          alt={currentHero.alt}
          fill
          className="object-cover opacity-20 transition-opacity duration-1000"
          priority
        />
      </div>

      <div className="container relative z-10 mx-auto px-4 py-32">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
          <div className="text-white">
            <h1 className="text-5xl md:text-7xl font-bold mb-6 transition-all duration-1000">{currentHero.title}</h1>
            <p className="text-xl md:text-2xl mb-8 max-w-2xl opacity-90 transition-all duration-1000">
              {currentHero.subtitle}
            </p>
            <div className="flex flex-col sm:flex-row gap-4">
              <Button asChild size="lg" className="bg-white text-teal-600 hover:bg-gray-100 text-lg px-8 py-4">
                <Link href="/signup">Join Now</Link>
              </Button>
              <Button
                asChild
                variant="outline"
                size="lg"
                className="border-white text-white hover:bg-white/10 text-lg px-8 py-4"
              >
                <Link href="/about">Learn More</Link>
              </Button>
            </div>
          </div>
          <div className="relative h-96 lg:h-full">
            <Image
              src={currentHero.src || "/placeholder.svg"}
              alt={currentHero.alt}
              fill
              className="object-contain transition-all duration-1000"
            />
          </div>
        </div>
      </div>

      {/* Carousel Indicators */}
      <div className="absolute bottom-8 left-1/2 transform -translate-x-1/2 flex space-x-2 z-20">
        {heroImages.map((_, index) => (
          <button
            key={index}
            onClick={() => setCurrentIndex(index)}
            className={`w-3 h-3 rounded-full transition-all duration-300 ${
              index === currentIndex ? "bg-white" : "bg-white/50"
            }`}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </section>
  )
}
